############### ###############
## T_H4_Awareness
## Project: CBO
## PI: Malte Lierl
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

# Hypothesis 4: A_breadth_awareness_sm_indicators --------------- ###### 

  ## a. Estimation: number of performance indicators remembered ####
  
  ### List of respondent type
  toestimate <- c("Mayor", "Deputy Mayor", "Opposition Member", "Secretary General")
  
  hyp4_indic <- rbind(
    
    AER::tobit(A_breadth_awareness_sm_indicators ~ treatmentcommune + factor(randomization_block) + #Region and security situation
                 factor(respondent_type),
               data = DM_final, #Individual level dataset derived from CBO level dataset
               weights = DM_weight, # Weights to compensate for th
               # unequal number of interviewee in each CBO
               na.action(na.omit),
               dist = "gaussian", 
               left = 0,
               right = 16) %>%
      coeftest(., 
               vcov = vcovCL(., 
                             #Clustering at CBO level
                             cluster = factor(DM_final$commune), #CBO id
                             type = "HC0")) %>% cbo_regression3(outcome.var = "A_breadth_awareness_sm_indicators") %>%
      mutate(Description = "number of performance indicators remembered") %>%
      mutate(control.group.mean = mean((DM_final %>%
                                          drop_na(A_breadth_awareness_sm_indicators, respondent_type) %>%
                                          filter(treatmentcommune == 0))$A_breadth_awareness_sm_indicators, na.rm = T)),
    
    ## b. Estimation: number of performance indicators remembered (for each respondent type)  ####
    
    map_dfr(toestimate, function(restype){
      AER::tobit(A_breadth_awareness_sm_indicators ~ treatmentcommune + factor(randomization_block),
                 data = DM_final %>% filter(respondent_type == restype), #Individual level dataset derived from CBO level dataset
                 weights = DM_weight, # Weights to compensate for th
                 # unequal number of interviewee in each CBO
                 na.action(na.omit),
                 dist = "gaussian", 
                 left = 0,
                 right = 16) %>%
        coeftest(., 
                 vcov = vcovCL(., 
                               #Clustering at CBO level
                               cluster = factor((DM_final %>% filter(respondent_type == restype))$commune), #CBO id
                               type = "HC0")) %>% cbo_regression3(outcome.var = "A_breadth_awareness_sm_indicators") %>%
        mutate(Description = "number of performance indicators remembered") %>%
        mutate(control.group.mean = mean((DM_final %>%
                                            filter(respondent_type == restype) %>%
                                            drop_na(A_breadth_awareness_sm_indicators) %>%
                                            filter(treatmentcommune == 0))$A_breadth_awareness_sm_indicators, na.rm = T))
    })
  )
  
  hyp4_indic$Description<- as.vector(c("All", 
                                       "Mayors",
                                       "Deputy Mayors",
                                       "Opposition Leaders",
                                       "Secretary Generals"))
  
  ## c. Number of clusters by group  ####
  clustersn <- DM_final %>% drop_na(A_breadth_awareness_sm_indicators) %>% distinct(commune) %>% nrow
  
  ## d. Number of observations censored at 0  & 16  ####
  ObsAt0 <- c("All" = nrow(DM_final %>% 
                             drop_na(A_breadth_awareness_sm_indicators, respondent_type) %>%
                             filter(A_breadth_awareness_sm_indicators <= 0)), 
              sapply(c("Mayor", "Deputy Mayor", "Opposition Member", "Secretary General"), function(res) 
                nrow(DM_final %>% 
                       drop_na(A_breadth_awareness_sm_indicators) %>%
                       filter(respondent_type == res & A_breadth_awareness_sm_indicators <= 0))))
  
  
  ObsAt16 <- c("All" = nrow(DM_final %>% 
                              drop_na(A_breadth_awareness_sm_indicators, respondent_type) %>%
                              filter(A_breadth_awareness_sm_indicators <= 16)), 
               sapply(c("Mayor", "Deputy Mayor", "Opposition Member", "Secretary General"), function(res) 
                 nrow(DM_final %>% 
                        drop_na(A_breadth_awareness_sm_indicators) %>%
                        filter(respondent_type == res & A_breadth_awareness_sm_indicators <= 16))))
  
  hyp4_indic <- as.data.frame(hyp4_indic) #Only was direct.textable() works
  
  ## e. Creating table  ####
  
  tbl.h4 <- function(row,value,digits=3) {
    stars <- ""
    if (hyp4_indic[row,'p.value']<0.1) {
      stars <- "$^{*}$"
      if (hyp4_indic[row,'p.value']<0.05) { 
        stars <- "$^{**}$"
        if (hyp4_indic[row,'p.value']<0.01) { 
          stars <- "$^{***}$"
        }
      }
    }
    
    if (value=='est') {
      return(paste0(signif(hyp4_indic[row,'estimate'], digits=digits), stars))
    }
    if (value=='se') {
      return(paste0("(",signif(hyp4_indic[row,'std.error'], digits=digits),")"))
    }
    if (value=="cgmean"){
      return(paste0(signif(hyp4_indic[row,'control.group.mean'], digits=digits)))
    }
  }
  
  tex("
        \\begin{tabularx}{\\textwidth}{l X X X X X}
        \\hline
        & \\multicolumn{5}{c}{\\emph{DV: Number of performance indicators remembered}}\\\\
        \\\\
        & (1) & (2) & (3) & (4) & (5) \\\\
        &  All & Mayors & Deputy Mayors & Opposition Leaders & Secretary General\\\\
        \\hline 
        \\\\
        \\emph{Control group mean} & <<tbl.h4(1,'cgmean')>>  & <<tbl.h4(2,'cgmean')>>  & <<tbl.h4(3,'cgmean')>>  & <<tbl.h4(4,'cgmean')>>  & <<tbl.h4(5,'cgmean')>> \\\\
        \\\\
        Treatment & <<tbl.h4(1,'est')>> & <<tbl.h4(2,'est')>> & <<tbl.h4(3,'est')>> & <<tbl.h4(4,'est')>> & <<tbl.h4(5,'est')>> \\\\
        & <<tbl.h4(1,'se')>> & <<tbl.h4(2,'se')>> & <<tbl.h4(3,'se')>> & <<tbl.h4(4,'se')>> & <<tbl.h4(5,'se')>> \\\\
        \\\\
        \\hline
        Observations & <<hyp4_indic[1,'observations']>> & <<hyp4_indic[2,'observations']>> & <<hyp4_indic[3,'observations']>> & <<hyp4_indic[4,'observations']>> & <<hyp4_indic[5,'observations']>> \\\\
        Censored at 0 & <<ObsAt0['All']>>  & <<ObsAt0['Mayor']>>  & <<ObsAt0['Deputy Mayor']>>  & <<ObsAt0['Opposition Member']>>  & <<ObsAt0['Secretary General']>>  \\\\
        Censored at 16 & <<ObsAt16['All']>>  & <<ObsAt16['Mayor']>>  & <<ObsAt16['Deputy Mayor']>>  & <<ObsAt16['Opposition Member']>>  & <<ObsAt16['Secretary General']>>  \\\\
        Clusters (Municipalities) & <<clustersn>>  & & & & \\\\
        \\hline \\hline
        \\end{tabularx}
    \\footnotesize{Coefficients from Tobit regressions with fixed effects for randomization blocks. Standard errors in parentheses, adjusted for clustering by municipality in column (1). $^{*} p<0.1$, $^{**} p<0.05$, $^{***} p<0.01$ (two-sided). }", 
                  file = here('Output/For Publication/Tables/T_H4_Awareness.tex'))
  
  rm(clustersn)



